/* exported print_log */
/* exported get_val_from_json */
/* exported mc_sdk_get_chip_list */
/* exported get_val_option */
/* exported get_grp_item_page_data */
/* exported get_single_item_page_data */
/* exported set_step_edit_val */
/* exported random_mod_size_val */
/* exported clear_mask */
/* exported get_alert_obj */
/* exported init_cick_animation */
/* exported get_option_list */
/* exported get_arr_random_val */
/* exported get_random_idx */


/* global mc_sdk_param */
/* global $ */
/* global obj_lang_map */
/* global G_STR_TEST_CLASS_NAME */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    打印日志,输出到控制台
 * 参数:
 *    @param { Promise<String> } str 日志 message
 *    @param { Promise<Boolean> } b 成功 || 失败 === false
 * 返回:
 *    @returns { Promise<Boolean> } true || false
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-10-26
 *       内容 : 所有代码
************************************************************************************************/
function print_log(str,b) {
    if ("string" !== typeof str || "boolean" !== typeof b) {
        return false;
    }

    if (b) {
        // console.log("[" + str + "]" + " " + "成功");
        console.log("[成功]" + "  " + str);
    } else {
        // console.log("[" + str + "]" + " " + "失败");
        console.log("[失败]" + "  " + str);
    }


    return true;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取sdk显示芯片列表;
 * 参数:
 *    @param { Promise<String> } str_ctrlchip 主控芯片值
 *    @param { Promise<Number> } ui_type 获取的芯片类型；0 === 行管芯片 || 1 === 显示芯片
 *    @param { Promise<String> } fun_callback 回调函数;参数为请求到的json串
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-10-27
 *       内容 : 所有代码
************************************************************************************************/
function mc_sdk_get_chip_list(str_ctrlchip, ui_type, fun_callback) {
    if ("function" !== typeof fun_callback || "number" !== typeof ui_type) {
        return;
    }
    if ("string" !== typeof str_ctrlchip || 0 >= str_ctrlchip.length) {
        fun_callback(false);
        return;
    }

    var STR_NAME_DISPCHIP = "DISPCHIP_LIST";
    var STR_NAME_SCANCHIP = "SCANCHIP_LIST";
    var str_fun = "";

    if (1 === ui_type) {
        str_fun = STR_NAME_DISPCHIP;
    } else if (0 === ui_type) {
        str_fun = STR_NAME_SCANCHIP;
    } else {
        return;
    }

    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_param_clear();
    obj_sdk_param.set_func(str_fun);
    obj_sdk_param.set_cmd("GET_PARAM");
    obj_sdk_param.set_param_value("CTRLCHIP", str_ctrlchip);
    $.post("/access_shell", obj_sdk_param.get_json(), function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }

        fun_callback(response);
        return;
    }, "text");
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    从json串获取val值并组成数组
 * 参数:
 *    @param { Promise<String> } str_name_id 对比json串的name_id值 === 只获取对应name_id下的value值 || false === 获取该json串所有param value值
 *    @param { Promise<String> } str_json 从sdk 请求回来的json串
 * 返回:
 *    @returns { Promise<Array> } 所有值组合的数组 || 空数组
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-10-27
 *       内容 : 所有代码
************************************************************************************************/
function get_val_from_json(str_name_id, str_json) {
    if ("string" !== typeof str_json) {
        return false;
    }

    if ("" === str_json.trim()) {
        return false;
    }

    var arr_res = [];
    var obj_sdk_param = new mc_sdk_param();

    obj_sdk_param.set_json(str_json);
    var ui_param_cnt = obj_sdk_param.get_param_cnt();

    if ("boolean" === typeof str_name_id && false === str_name_id) {
        for (var ui_idx = 0; ui_idx < ui_param_cnt; ui_idx++) {
            var str_param_name = obj_sdk_param.get_param_name(ui_idx);

            if ("ERROR_CODE" !== str_param_name) {
                var str_param_value = obj_sdk_param.get_param_value(str_param_name);

                var str_trans = obj_lang_map[str_param_value];

                if (str_trans) {
                    arr_res.push(str_trans);
                } else {
                    arr_res.push(str_param_value);
                }
            }
        }


        return arr_res;
    }


    var str_res = "";

    for (var ui_i = 0; ui_i < ui_param_cnt; ui_i++) {
        var str_p_name = obj_sdk_param.get_param_name(ui_i);

        if ("ERROR_CODE" !== str_p_name && str_name_id === str_p_name) {
            str_res = obj_sdk_param.get_param_value(str_p_name);
            break;
        }
    }

    var arr_split = str_res.split(",");
    var ui_len = arr_split.length;

    for (var ui_i_list = 0; ui_i_list < ui_len; ui_i_list++) {
        var item = arr_split[ui_i_list];

        if ("undefined" === item) {
            continue;
        }

        arr_res.push(item);
    }

    return arr_res;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取一组控件的页面值
 * 参数:
 *    @param { Promise<Object> }  obj 包裹一组控件的dom对象
 * 返回:
 *    @returns { Promise<Array> } 返回一组值 || false
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function get_grp_item_page_data(obj) {
    if (obj) {
        var arr_res = [];
        var arr_item = obj.querySelectorAll("." + G_STR_TEST_CLASS_NAME);
        var obj_construct_data = new get_single_item_page_data();

        arr_item.forEach(function (el,idx) {
            var el_val = obj_construct_data.get_data(el);

            arr_res[idx] = el_val;
        });

        return arr_res;
    }
    return false;
}


/************************************************************************************************
 * 类型:
 *    函数: 构造函数
 * 功能:
 *    获取单个控件的页面值
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function get_single_item_page_data() {
    var m_test_cname = G_STR_TEST_CLASS_NAME;
    // 控件测试类和调用方法
    var m_obj_item_cname_map = {
        "mc_test_option": "get_val_option",
        "mc_test_step_edit": "get_val_step_edit",
        "mc_test_checkbox": "get_val_chekbox",
        "mc_test_radio": "get_val_radio"
    };


    /************************************************************************************************
     * 类型:
     *    函数
     * 功能:
     *    函数功能
     * 参数:
     *    @param { Promise<Object> } obj
     * 返回:
     *    @returns { Promise<String> } 参数1
     * 例子:
     *    NA
     * 备注:
     *    NA
     * 修改:
     *    1. 类型 : 创建
     *       作者 : 巫昭雯
     *       时间 : 2020-11-10
     *       内容 : 所有代码
    ************************************************************************************************/
    this.get_data = function (obj) {
        if (obj) {
            var str_fun_name = "";
            var arr_class = obj.classList;
            var ui_calss_len = arr_class.length;

            for (var ui_i = 0; ui_i < ui_calss_len; ui_i++) {
                var str = arr_class[ui_i];

                if (str === m_test_cname) {
                    continue;
                }

                if (-1 === str.indexOf("mc_test_")) {
                    continue;
                }

                if (m_obj_item_cname_map[str]) {
                    str_fun_name = m_obj_item_cname_map[str];
                    break;
                }
            }

            if ("" === str_fun_name.trim()) {
                return false;
            }

            if ("function" === typeof this[str_fun_name]) {
                return this[str_fun_name](obj);
            }
            return null;
        }
        return false;
    };


    this.get_val_option = function (obj) {
        if (obj) {
            var str_val = obj.getAttribute("mc_select_default");

            str_val = obj.querySelector(".select_txt").innerText;

            return str_val;
        }
        return false;
    };


    this.get_val_step_edit = function (obj) {
        var str_inp_cname = "mc_step_inp";

        if (obj) {
            var obj_inp = obj.querySelector("." + str_inp_cname);

            if (obj_inp) {
                // return obj_inp.innerText;
                return obj_inp.getAttribute("value");
            }
        }
        return false;
    };


    this.get_val_chekbox = function (obj) {
        if (obj) {
            var str_val = obj.getAttribute("checkbox_select");

            return str_val;
        }
        return null;
    };


    this.get_val_radio = function (obj) {
        if (obj) {
            var str_val = obj.getAttribute("select_index");

            return str_val;
        }
        return null;
    };
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    设置步进编辑框值
 * 参数:
 *    @param { Promise<Object> } obj 步进编辑框对象
 *    @param { Promise<Number> } val 设置的值
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function set_step_edit_val(obj,val) {
    if (obj && val) {
        var str_inp_cname = "mc_step_inp";
        var obj_inp = obj.querySelector("." + str_inp_cname);

        if (obj_inp) {
            obj_inp.innerText = val;
            obj_inp.value = val;
            obj_inp.onblur(obj_inp);
        }
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    随机模组大小值
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Number> } 随机的大小值
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function random_mod_size_val() {
    // return ((Number((Math.random() * 10).toFixed()) + 1) * 8);\
    var arr_size = [16,32,64,128];
    var ui_idx = Math.floor((Math.random() * arr_size.length));

    return arr_size[ui_idx];
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    清楚遮罩
 * 参数:
 *    @param { Promise<Object> } obj_ifram  id === iframe_subpage 的iframe
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-03
 *       内容 : 所有代码
************************************************************************************************/
function clear_mask(obj_ifram) {
    if (obj_ifram) {
        var obj_mask = obj_ifram.contentDocument.getElementById("mc_loading_box");

        if (obj_mask) {
            obj_mask.parentElement.removeChild(obj_mask);
        }
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取弹框对象并操纵
 * 参数:
 *    @param { Promise<Object> } obj_iframe  id === iframe_subpage 的iframe
 *    @param { Promise<String> } b_ok true === 执行确定按钮事件 || false === 执行取消按钮事件
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-03
 *       内容 : 所有代码
************************************************************************************************/
function get_alert_obj(obj_iframe ,b_ok) {
    // layui-layer
    if (obj_iframe) {
        var obj_alert = obj_iframe.contentDocument.querySelector(".layui-layer");

        if (obj_alert) {
            if (b_ok) {
                var obj_btn_ok = obj_alert.querySelector(".layui-layer-btn0");

                obj_btn_ok.click();
            } else {
                var obj_btn_cancel = obj_alert.querySelector(".layui-layer-btn1");

                obj_btn_cancel.click();
            }
        }
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取下拉列表的选项 构造函数
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function get_option_list() {
    /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    获取下拉列表框的 选项对象(li 对象集合)
         * 参数:
         *    @param { Promise<Object> } obj 带有下拉列表框的外包裹对象
         * 返回:
         *    @returns { Promise<Object> } 获取到的对象集合 || false
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2020-10-27
         *       内容 : 所有代码
        ************************************************************************************************/
    function get_li_obj(obj) {
        if (obj) {
            var obj_list = obj.querySelector("." + "select_list").getElementsByTagName("li");

            if (obj_list) {
                return obj_list;
            }
        }
        return false;
    }

    // 对外接口：获取下拉列表内的选项对象 obj === 下拉列表控件dom对象
    this.io_get_li_obj = function (obj) {
        var res = get_li_obj(obj);

        if (res) {
            return res;
        }
        return false;
    };

    // 对外接口：获取下拉列表的选项值 obj === 下拉列表控件dom对象
    this.io_get_list_val = function (obj) {
        var res = get_li_obj(obj);

        if (res) {
            var arr = [];

            for (var ui_i = 0; ui_i < res.length; ui_i++) {
                var obj_item = res[ui_i];

                arr.push(obj_item.innerText);
            }

            return arr;
        }

        return false;
    };


    // return false;
}


function get_arr_random_val(arr) {
    if ("[object Object]" !== Object.prototype.toString.call(arr)) {
        return false;
    }

    var ui_idx = Math.floor((Math.random() * arr.length));

    return arr[ui_idx];
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取随机下标
 * 参数:
 *    @param { Promise<Number> } len 数组的长度
 * 返回:
 *    @returns { Promise<Number> } 随机下标 || false
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2020-11-10
 *       内容 : 所有代码
************************************************************************************************/
function get_random_idx(len) {
    if ("number" !== typeof len) {
        return false;
    }

    if (len) {
        return Math.floor(Math.random() * len);
    }
    return false;
}

